property captain : ""
property game : ""
property competition : ""
property keeper : ""
property auth : ""
property kick : ""
property kickoff : ""
global s

on english()
    set captain to "Firewall" as text
    set game to "Security & Privacy" as text
    set competition to "View" as text
    set keeper to "Click the lock to make changes." as text
    set auth to "Authenticating…" as text
    set kick to "Turn On Firewall" as text
    set kickoff to "Turn Off Firewall" as text
end english

on dutch()
    set captain to "Firewall" as text
    set game to "Beveiliging en privacy" as text
    set competition to "Weergave" as text
    set keeper to "Klik op het hangslot om de instellingen te wijzigen." as text
    set auth to "Identiteitscontrole…" as text
    set kick to "Schakel firewall in" as text
    set kickoff to "Schakel firewall uit" as text
end dutch

on thai()
    set captain to "ไฟร์วอลล์" as text
    set game to "ความปลอดภัยและความเป็นส่วนตัว"
    set competition to "มุมมอง"
    set keeper to "คลิกล็อกเพื่อทำการเปลี่ยนแปลง"
    set auth to "กำลังรับรองความถูกต้อง…"
    set kick to "เปิดไฟร์วอลล์"
    set kickoff to "ปิดไฟร์วอลล์"
end thai


on appRunning(_name)
    tell application "System Events" to set _running to exists (processes where name is _name)
    return _running
end appRunning

on mavericks()
    
    tell application "System Events"
        tell application "System Preferences"
            activate
            reveal anchor "Firewall" of pane id "com.apple.preference.security"
        end tell
    end tell
    
    tell application "System Events"
        tell application process "System Preferences"
            try
                click radio button captain of tab group 1 of window game
            end try
            delay 0.25
            
            try
                click menu item game of menu competition of menu bar 1
            end try
            
            if title of button 4 of window 1 is keeper then
                click button 4 of window 1
            end if
            
            
            repeat while title of button 4 of window 1 is auth
                delay 1
            end repeat
            
            
            try
                click button 2 of tab group 1 of window game
                on error errMsg
            end try
            
            set visible to false
        end tell
    end tell
    
    tell application "System Preferences" to quit
end mavericks


on yosemite()
    
    tell application "System Preferences" to activate
    
    tell application "System Events"
        tell process "System Preferences"
            
            repeat 10 times
                if (exists (menu item game of menu competition of menu bar 1)) then
                    exit repeat
                    else
                    delay 0.25
                end if
                
            end repeat
            
            
            if not (exists (menu item game of menu competition of menu bar 1)) then
                display alert "Waiting too long for System Preferences"
                tell me to quit
            end if
            
            click menu item game of menu competition of menu bar 1
            delay 0.25
            
            tell window 1
                tell tab group 1
                    click radio button captain
                    delay 0.5
                    
                end tell
                
                
                if exists (button keeper) then
                    click button keeper
                end if
                delay 2
            end tell
            
            repeat while exists (button auth of window 1)
                delay 0.5
            end repeat
            
            tell window 1
                if exists (button kick of tab group 1) then
                    click button kick of tab group 1
                    else
                    click button kickoff of tab group 1
                end if
            end tell
            
            set visible to false
        end tell
    end tell
    
    tell application "System Preferences" to quit
end yosemite


on elcapitan()
    
    tell application "System Preferences" to activate
    
    tell application "System Events"
        tell process "System Preferences"
            
            repeat 10 times
                if (exists (menu item game of menu competition of menu bar 1)) then
                    exit repeat
                    else
                    delay 0.25
                end if
                
            end repeat
            
            
            if not (exists (menu item game of menu competition of menu bar 1)) then
                display alert "Waiting too long for System Preferences"
                tell me to quit
            end if
            
            click menu item game of menu competition of menu bar 1
            
            tell window 1
                repeat 10 times
                    if (exists (radio button captain of tab group 1 of window game of application process "System Preferences" of application "System Events")) then
                        exit repeat
                        else
                        delay 0.25
                    end if
                    
                end repeat
                set rb to radio button captain of tab group 1 of window game of application process "System Preferences" of application "System Events"
                tell rb to click
                delay 0.5
                
                
                
                if exists (button keeper) then
                    click button keeper
                end if
                delay 2
            end tell
            
            repeat while exists (button auth of window 1)
                delay 0.5
            end repeat
            
            tell window 1
                if exists (button kick of tab group 1) then
                    click button kick of tab group 1
                    else
                    click button kickoff of tab group 1
                end if
            end tell
            
            set visible to false
        end tell
    end tell
    
    tell application "System Preferences" to quit
end elcapitan



on run
    
    set s to text 4 of (system info)'s system version
    set ss to text 5 of (system info)'s system version
    
    
    set l to text 1 thru 2 of (system info)'s user locale
    if l is equal to "nl" then
        dutch()
        else if l is equal to "th" then
        thai()
        else
        english()
    end if
    
    if appRunning("System Preferences") then
        tell application "System Preferences" to quit
    end if
    delay 0.5
    
    tell application "System Preferences" to activate
    
    if s is equal to "1" then
        if ss is equal to "0" then
            yosemite()
            else
            elcapitan()
        end if
    else
        mavericks()
    end if
end run

